; Name:		GroupWise Address Book.jss
; Topic:	JAWS Script File for GroupWise Address Book

; Copyright (C) 2005 Novell Inc., All Rights Reserved
; COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION

include "hjconst.jsh"
Include "Hjglobal.jsh"
include "common.jsm"
include "tutorialhelp.jsm"
include "GroupWise Address Book.jsh"
include "GroupWise Address Book.jsm"

const
	IM_GROUP_IM				= 310,
	IM_PROVIDER				= 411,
	LDAP_FIELD_LIST		= 6000

	; The following is defined in hjconst.jsh for jaws 6.0 and later.
	; For Jaws 5.x we need to define it so this script will compile.
	;OT_HIGHLIGHTED_SCREEN_TEXT=43

globals
	int		g_ABVersion,
	int		g_iLastFocusedItem,
	int     bSayFocusWindowSameAsLast,
	handle g_hwndLastSayFocusWindow,
	handle g_hwndNull	;By default, this variable is initialized to NULL.
						;We use it in 'if' statements and to set other 
						;'handles' to NULL


void Function AutoStartEvent ()
;;;TrcEnter("AutoStartEvent:GroupWise Address Book")
let g_ABVersion = GetVersion();
;;;OutputDebugString(FormatString("GW Address Book Version=%1",IntToString(g_ABVersion)))
;;;OutputDebugString(FormatString("JAWS Version=%1",IntToString(GetJFWVersion())))
let iTogglePageReading = iniReadInteger(Section_applicationVerbositySettings,hKey_ReadMessage, FALSE,jsiFileName)
AutoStartEvent ()
;;;TrcExit("AutoStartEvent:GroupWise Address Book")
EndFunction


; function to find a window based on a control id
handle Function FindWindowFromId (handle hWnd, int nId)

	return FindDescendantWindow (GetRealWindow (hWnd), nId)
EndFunction


int Function GetVersion ()
; This function builds an integer value from the program version information.
; This value is used with in the scripts to determine which version of 
;   AddrBook is being executed.
var
	int iValue,
	string sVersion

let sVersion = GetVersionInfoString (GetAppFilePath (), cs_ProductVersion)
let iValue = stringToInt (StringSegment (sVersion, ".", 1))
let iValue = stringToInt (StringSegment (sVersion, ".", 2)) + iValue * 10 
let iValue = stringToInt (StringSegment (sVersion, ".", 3)) + iValue * 10
return iValue;
endFunction


string function GetAppVersion ()
var
	string sProduct,
	string sVersion,
	string sMessage
let sProduct = GetVersionInfoString (GetAppFilePath (), cs_ProductName)
let sVersion = GetVersionInfoString (GetAppFilePath (), cs_ProductVersion)
let sMessage = FormatString (cmsg239_L, sProduct, sVersion)
return sMessage
EndFunction


string function GetCustomTutorMessage()
var
	handle	hwndControl,
	string	sCustomTutorMessage

	let hwndControl = GlobalFocusWindow
	let sCustomTutorMessage = cscNull

	if ((IDC_CONTACT_PHOTO == GetControlId(hwndControl)) && 
	   (WCN_BUTTON == GetWindowClass(hwndControl)) &&
	   (WCN_DIALOG == GetWindowClass(GetParent(hwndControl)))) then
      		let sCustomTutorMessage = msgContactPhotoTutor
	endif

	return sCustomTutorMessage
endfunction


Function SayFocusedWindow()
;;;TrcEnter("SayFocusedWindow")

var
	int iControlId,
	int iParentId,
	
	handle	hwndControl,
	handle hwndParent,

	string	sControlClassName,
	string	sParentClassName

	let hwndControl = GlobalFocusWindow
	let hwndParent = GetParent(hwndControl)
	let iControlId = GetControlId(hwndControl)
	let iParentId = GetControlId(hwndParent)
	let sControlClassName = GetWindowClass(hwndControl)
	let sParentClassName = GetWindowClass(hwndParent)

	;;;OutputDebugString(FormatString("--ControlId=%1",IntToString(iControlId)))
	;;;OutputDebugString(FormatString("--ClassName=%1", sControlClassName ))
	;;;OutputDebugString(FormatString("--Type=%1",IntToString(GetWindowTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--Subtype=%1",IntToString(GetWindowSubTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--ParentId=%1",IntToString(iParentId)))
	;;;OutputDebugString(FormatString("--ParentClass=%1",sParentClassName))
	;;;OutputDebugString(FormatString("--ParentType=%1",IntToString(GetWindowTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--ParentSubtype=%1",IntToString(GetWindowSubTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--RealClassName=%1",GetWindowClass(GetRealWindow(hwndControl))))
	;;;OutputDebugString(FormatString("----GetItemCount=%1",IntToString(GetItemCount(hwndControl))))

	;Say the controls for deleting and editing comments in the Notes Tab (Contact Information Dialog)
	if (GetWindowClass(hwndControl) == CWCIEServer && GetWindowClass(GetParent (hwndControl)) == WCN_HTMLMessageWindow
	    && GetWindowClass(GetParent(GetParent(hwndControl))) == WC_SHELL && GetWindowText(GetNextWindow(GetParent(GetParent(GetParent(hwndControl)))),0) == WN_Categories) then	
		Refresh()
		if (StringCompare(GetObjectName(),"#1") == 0 || StringCompare(GetObjectName(),"Delete") == 0) then
			SayFormattedMessage(OT_NO_DISABLE,  MSG_DELETECOMMENT)
			return
		endif
		if (StringCompare(GetObjectName(),"#2") == 0 || StringCompare(GetObjectName(),"Edit") == 0) then
			SayFormattedMessage(OT_NO_DISABLE,  MSG_EDITCOMMENT)
			return
		endif
	endif

	var
				handle hwndLabel

	;Say what these buttons are for (in Contact Information Dialog)
	if (sControlClassName == wcn_Button && sParentClassName == wcn_Dialog && GetWindowClass(GetParent(hwndParent)) == wcn_Dialog) then
		if (iControlId == CID_COMPANY_INFORMATION) then
			SayFormattedMessage(OT_NO_DISABLE,  msgCompanyInformation)
			IndicateControlType(WT_BUTTON)
   		return
		endif
		if (iControlId == IDC_CONTACT_PHOTO) then
			SayFormattedMessage(OT_NO_DISABLE,  msgContactPhoto)
			IndicateControlType(WT_BUTTON)
   		return
		endif
		if (iControlId == IDC_ENABLE_BIRTHDAY) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_BIRTHDAY)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel),"","","","","","","")
   		return
		endif	
		if (iControlId == IDC_VIEW_BIRTHDAY) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_BIRTHDAY)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel)+msgViewBirthdayInCalendar,"","","","","","","")
   		return
		endif
		if (iControlId == IDC_ENABLE_ANNIVERSARY) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_ANNIVERSARY)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel),"","","","","","","")
   		return
		endif		
		if (iControlId == IDC_VIEW_ANNIVERSARY) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_ANNIVERSARY)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel)+msgViewAnniversaryInCalendar,"","","","","","","")
   		return
		endif
		if (iControlId == IDC_LAUNCH_OFFICE_WEBSITE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_OFFICE_WEBSITE)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel)+msgLaunchOfficeWebsite,"","","","","","","")
   		return
		endif
		if (iControlId == IDC_LAUNCH_PERSONAL_WEBSITE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_PERSONAL_WEBSITE)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel)+msgLaunchPersonalWebsite,"","","","","","","")
   		return
		endif
	endif

	;Say what these EDIT BOX are for (in Contact Information Dialog)
	if (sControlClassName == wcn_Edit && sParentClassName == wcn_Dialog && GetWindowClass(GetParent(hwndParent)) == wcn_Dialog) then		
		if (iControlId == IDC_FULLNAME) then
			SayControlEx(hwndControl,msgFullName,"","","","","","","")
   		return
		endif
		if (iControlId >= IDC_OFFICE_ADDRESS && iControlId <= IDC_OFFICE_POSTALCODE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_OFFICE_ADDRESS)
			if (iControlId == IDC_OFFICE_ADDRESS) then
				SayControlEx(hwndControl,msgStreetAddress,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OFFICE_CITY) then
				SayControlEx(hwndControl,msgCity,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OFFICE_STATE) then
				SayControlEx(hwndControl,msgState,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OFFICE_POSTALCODE) then
				SayControlEx(hwndControl,msgPostalCode,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			return
		endif
		if (iControlId >= IDC_HOME_ADDRESS && iControlId <= IDC_HOME_POSTALCODE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_HOME_ADDRESS)
			if (iControlId == IDC_HOME_ADDRESS) then
				SayControlEx(hwndControl,msgStreetAddress,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_HOME_CITY) then
				SayControlEx(hwndControl,msgCity,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_HOME_STATE) then
				SayControlEx(hwndControl,msgState,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_HOME_POSTALCODE) then
				SayControlEx(hwndControl,msgPostalCode,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			return
		endif
		if (iControlId >= IDC_OTHER_ADDRESS && iControlId <= IDC_OTHER_POSTALCODE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_OTHER_ADDRESS)
			if (iControlId == IDC_OTHER_ADDRESS) then
				SayControlEx(hwndControl,msgStreetAddress,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OTHER_CITY) then
				SayControlEx(hwndControl,msgCity,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OTHER_STATE) then
				SayControlEx(hwndControl,msgState,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OTHER_POSTALCODE) then
				SayControlEx(hwndControl,msgPostalCode,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			return
		endif
	endif

	;Say what these COMBO BOX are for (in Contact Information Dialog)
	if (sParentClassName == wcn_ComboBox && GetWindowClass(GetParent(hwndParent)) == wcn_Dialog && GetWindowClass(GetParent(GetParent(hwndParent))) == wcn_Dialog) then
		if ((iControlId == IDC_EDIT_COUNTRY)  && (sControlClassName == wcn_Edit)) then
			if (iParentId == IDC_OFFICE_COUNTRY) then
				let hwndLabel = FindWindowWithClassAndId(GetParent(hwndParent),"Static",IDC_LABEL_OFFICE_ADDRESS)
				SayControlEx(hwndControl,msgCountry,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iParentId == IDC_HOME_COUNTRY) then
				let hwndLabel = FindWindowWithClassAndId(GetParent(hwndParent),"Static",IDC_LABEL_HOME_ADDRESS)
				SayControlEx(hwndControl,msgCountry,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iParentId == IDC_OTHER_COUNTRY) then
				let hwndLabel = FindWindowWithClassAndId(GetParent(hwndParent),"Static",IDC_LABEL_OTHER_ADDRESS)
				SayControlEx(hwndControl,msgCountry,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			return				
		endif
	endif

; If this window is the same as the last window we 'spoke', set flag TRUE
;

if (GlobalFocusWindow == g_hwndLastSayFocusWindow) then
	let bSayFocusWindowSameAsLast = TRUE
else
	let bSayFocusWindowSameAsLast = FALSE
endif
let g_hwndLastSayFocusWindow = GlobalFocusWindow	; Save for next time we are called

; Defect 373428.
; Say the control name for the "Invoke Address Book button"
;
if (iControlId == IDC_ABCSP_NAME_AB_BUTTON) && 
   (sParentClassName == wcn_Dialog ) &&
   (sControlClassName == wcn_Button) then
	SayControlExWithMarkup(hwndControl, msg_Address_Book)
	;;;TrcExit("SayFocusedWindow-2")
	return;
endif

; Defect 422145.
; Say the control name for the NCC edit box.
;
if (sControlClassName == wcn_Edit) &&
	(iParentId == IDC_ABCSP_NAME_NCC) &&
	(sParentClassName == wcn_ABEntryField) then
	SayControlExWithMarkup( hwndControl, 
			GetWindowText( FindDescendantWindow(GetParent(hwndParent), IDC_ABCSP_NAME_TITLE), Read_Everything))
	;;;TrcExit("SayFocusedWindow-3")
	return
endif

; Defect 422147
; Say the control name for the "list view"
;
if (iControlId == IDC_ABCSP_SH_LIST) &&
	(sParentClassName == wcn_Dialog) then
	SayControlExWithMarkup( hwndControl,
		GetWindowText( FindDescendantWindow( hwndParent, IDC_ABCSP_SH_TITLE), Read_Everything))
	;;;TrcExit("SayFocusedWindow-4")
	return
endif

	; Check to see if the control is the IM Provider
	; if so, say the window name of the group control
	if (iControlId == IM_PROVIDER) then
		var	handle	hGroupIM

		let hGroupIM = FindWindowFromId (hwndControl, IM_GROUP_IM)

		SayString (GetWindowName (hGroupIM))
	endif

;If the focus changes to the properties list in the Advanced tab of
;Contact Details, forget the last focused item. In this way JAWS will
;say the list (SayFocusedObject()) and the item in the list
If (GetWindowTypeCode(GetParent(GlobalFocusWindow)) == WT_LISTVIEW) && (iControlId == CID_POPUP_EDIT) Then
	If (!bSayFocusWindowSameAsLast) Then
		SayFocusedObject ()
		let g_iLastFocusedItem = 0
		;;;TrcExit("SayFocusedWindow-5")
		return
	EndIf
EndIf

; If the control is part of the IE font dialog, call default 
; SayFocusedWindow and return. We must do this check BEFORE calling 
; SayHTMLParagraphWindow.  Otherwise the "Internet Explorer_Server" 
; window that is part of the IE Font Dialog is mistaken for a 
; message window.
;
If IsDescendent( GlobalFocusWindow, WCN_IE_TRIDENTDLGFRAME) Then
	SayFocusedWindow()
	;;;TrcExit("SayFocusedWindow-6")
	return
EndIf
if (GetWindowClass( GlobalFocusWindow) == cwcIEServer) Then
    SayHTMLParagraphWindow()
	;;;TrcExit("SayFocusedWindow-7")
	return
EndIf

; Invoke the default SayFocusedWindow
;
;;;OutputDebugString("--Defaulting to common:SayFocusedWindow")
SayFocusedWindow ()
;;;TrcExit("SayFocusedWindow")
EndFunction

; HighlightedText Function for speaking all newly written highlighted text.
Void Function SayHighLightedText (handle hWnd, string sBuffer)
	var
		int			nWinType,
		int			nControlId,
		string		sClass

	let nWinType	= GetWindowSubTypeCode (hWnd)
	let nControlId	= GetControlId (hWnd)

	if (GetScreenEcho() > 0) then
		if (nWintype == wt_ListView) then

			; If this is the ldap search field list, we dont' want it to say the check box value
			; because it's saying it wrong.

			if (nControlId == LDAP_FIELD_LIST) then
				Say (sBuffer, OT_HIGHLIGHTED_SCREEN_TEXT)
				return
			endif
		EndIf
	endIf

	SayHighLightedText (hWnd, sBuffer)
EndFunction

; called when focus changes
void Function FocusChangedEvent (handle hFocusWnd, handle hPrevWnd)
	var
		handle hRealWindow,
		handle hCurrentFocus,
		string		sRealWindowName,
		int			nDlgId,
		int			iControlId


	let hCurrentFocus				=	GetFocus()
	let hRealWindow				= GetRealWindow (hFocusWnd)
	let sRealWindowName	= GetWindowName (hRealWindow)
	let iControlId							=	GetControlID(hCurrentFocus)

	; If we're at the Search Fields dialog, intercept and return
	if (sRealWindowName == "Search Fields") then
		SayWindowTypeAndText (hRealWindow)
		SayFocusedWindow ()
		return
	endif

	If ( iControlID	==	IDC_HEADERBITMAP	
			&&	GetControlID(GetParent(hCurrentFocus)) == IDC_HEADERCONTROL
			&& sRealWindowName == WN_AddressBook)	then   
				SayFormattedMessage (OT_help, cmsg6_L+msgButton)
				return
	EndIf

	If ( iControlID	==	IDC_HEADERTEXT	
			&&	GetControlID(GetParent(hCurrentFocus)) == IDC_HEADERCONTROL
			&& sRealWindowName == WN_AddressBook)	then	
		SayString(GetTextInWindow(hCurrentFocus))
		SayFormattedMessage (OT_help, msgButton)	
		return
	EndIf


	FocusChangedEvent (hFocusWnd, hPrevWnd	&&	GetControlID(GetParent(hCurrentFocus)) == IDC_HEADERCONTROL)
EndFunction

Script SayPriorLine()
	;TrcEnter("SayPriorLine")
	var
		int iControlId,
		int iParentId,
		handle hwndParent,
		string	sControlClassName,
		string	sParentClassName,
		int iParentTypeCode
	
	let hwndParent = GetParent(GlobalFocusWindow)
	let iControlId = GetControlId(GlobalFocusWindow)
	let iParentId = GetControlId(hwndParent)
	let iParentTypeCode = GetWindowTypeCode (hwndParent)
	
	If (iParentTypeCode == WT_LISTVIEW) && (iControlId == CID_POPUP_EDIT) Then
		If (SayItemInContactPropertiesList(GlobalFocusWindow)==FALSE) Then
			PriorLine()
			;TrcExit("SayPriorLine-0")
			Return
		EndIf
	EndIf
	;TrcExit("SayPriorLine-1")
	PerformScript SayPriorLine()
EndScript

Script SayNextLine()
	;TrcEnter("SayNextLine")
	var
		int iControlId,
		int iParentId,
		handle hwndParent,
		string	sControlClassName,
		string	sParentClassName,
		int iParentTypeCode
	
	let hwndParent = GetParent(GlobalFocusWindow)
	let iControlId = GetControlId(GlobalFocusWindow)
	let iParentId = GetControlId(hwndParent)
	let iParentTypeCode = GetWindowTypeCode (hwndParent)
	
	If (iParentTypeCode == WT_LISTVIEW) && (iControlId == CID_POPUP_EDIT) Then
		If (SayItemInContactPropertiesList(GlobalFocusWindow)==FALSE) Then
			NextLine()
			;TrcExit("SayNextLine-0")
			Return
		EndIf
	EndIf
	;TrcExit("SayNextLine-1")
	PerformScript SayNextLine()
EndScript

Void Function SayNonHighlightedText (handle hwnd, string buffer)
;;;TrcEnter("SayNonHighlightedText")
; NonHighlightedText  Function for speaking all newly written nonhighlighted
; text.

If (GetWindowTypeCode(GetParent(GetFocus())) == WT_LISTVIEW) && (GetControlId(GetFocus()) == CID_POPUP_EDIT) Then
	SayItemInContactPropertiesList(GetFocus())
EndIf
EndFunction

int Function SayItemInContactPropertiesList(handle hwndControl)
	;TrcEnter("SayItemInContactPropertiesList")
	If (GetJFWVersion()<510000) Then
		;TrcExit("SayItemInContactPropertiesList-return FALSE-0")
		return FALSE;
	EndIf 
	var
		int iControlId,
		int iParentId,
		handle hwndParent,
		int iParentTypeCode

	let hwndParent = GetParent(hwndControl)
	let iControlId = GetControlId(hwndControl)
	let iParentId = GetControlId(hwndParent)
	let iParentTypeCode = GetWindowTypeCode (hwndParent)

	;;;OutputDebugString(FormatString("--ControlId=%1",IntToString(iControlId)))
	;;;OutputDebugString(FormatString("--Type=%1",IntToString(GetWindowTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--Subtype=%1",IntToString(GetWindowSubTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--ParentId=%1",IntToString(iParentId)))
	;;;OutputDebugString(FormatString("--ParentType=%1",IntToString(GetWindowTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--ParentSubtype=%1",IntToString(GetWindowSubTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--RealClassName=%1",GetWindowClass(GetRealWindow(hwndControl))))
	;;;OutputDebugString(FormatString("----GetItemCount=%1",IntToString(GetItemCount(hwndControl))))

	If (iParentTypeCode == WT_LISTVIEW) && 	(iControlId == CID_POPUP_EDIT) Then
		var
				int i,
				int iFocusedItem,
				int iColumns,
				int iLeft,
				int iRight,
				int iTop,
				int iBottom,
				string sItemText,
				string sColHeader,
				string sGraphicName
		let iColumns = lvGetNumOfColumns (hwndParent)
		let iFocusedItem = lvGetFocusItem (hwndParent)

		;If the focus have not changed of selected item then return
		If (g_iLastFocusedItem== iFocusedItem) Then
			;TrcExit("SayItemInContactPropertiesList-return FALSE-1")
			return FALSE;
		EndIf
		
		;When the focus is in a new item, remember this item using g_iLastFocusedItem
		let g_iLastFocusedItem = iFocusedItem

		;Say the graphic that is in the item
		if (lvGetItemRect(hwndParent,iFocusedItem,iLeft,iRight,iTop,iBottom)) Then
			let sGraphicName=GetGraphicNameAtPoint(iLeft+(iBottom-iTop)/2,iTop+(iBottom-iTop)/2)
			SayFormattedMessage (OT_NO_DISABLE, sGraphicName)
		EndIf
		;Say the info that is in the columns of the item
		let i = 1
		while(i <= iColumns)
			let sColHeader = lvGetColumnHeader (hwndParent,i )
			let sItemText =  lvGetItemText (hwndParent,iFocusedItem,i ) 
			if (sColHeader && sItemText) then
				SayFormattedMessage (OT_NO_DISABLE, sColHeader)	
				SayFormattedMessage (OT_NO_DISABLE, sItemText)
			endif
			let i = i + 1
		endwhile
		;Say the number of item that has been selected
		SayFormattedMessage (OT_NO_DISABLE, FormatString("Item %1 of %2",IntToString( iFocusedItem ),IntToString(lvGetItemCount (hwndParent))))
		
		;TrcExit("SayItemInContactPropertiesList-return TRUE")
		return TRUE
	EndIf
	;TrcExit("SayItemInContactPropertiesList-return FALSE-2")
	return FALSE
EndFunction

;----------------------------------------------------------------------
; IsDescendent
; If the window handle is a descendent of a window with the specified
; class name, return the window handle of the ancestor window.
;----------------------------------------------------------------------
Handle Function IsDescendent( handle hwnd, string sAncestorClass)
var int bIsDescendent
let bIsDescendent = FALSE
while (hwnd)
	let hwnd = GetParent(hwnd)
	if (GetWindowClass(hwnd) == sAncestorClass) then
		return hwnd;
	endif
endwhile
return g_hwndNull
EndFunction

;----------------------------------------------------------------------
; SayHTMLParagraphWindow
; If the focus is set to a window with cwcIEServer as class name 
; (Internet Explorer_Server). SayFocusedWindow will issue
; SayHTMLParagraphWindow to process text paragraphs inside the HTML
; window.
;----------------------------------------------------------------------
Function SayHTMLParagraphWindow()
;;;TrcEnter("SayHTMLParagraphWindow")
Var
	string sTitle

let sTitle = GetAppTitle ()
;;;OutputDebugString(sTitle)
If ((GetWindowClass (GlobalFocusWindow) == cwcIEServer) && (iTogglePageReading == FALSE) &&
    (GetWindowClass (GetParent (GlobalFocusWindow)) == WCN_HTMLMessageWindow) && 
    (GetWindowClass (GetRealWindow (GlobalFocusWindow)) == wcn_Dialog) &&
    (StringContains(GetWindowName(GetTopLevelWindow(GetFocus())), "Organization") )) Then
    If ((bSayFocusWindowSameAsLast == FALSE)) Then
        If ((PriorParagraph() == TRUE)) Then
            SayParagraph()
        Else
            SayParagraph()
        EndIf
        If ((NextParagraph() == TRUE)) Then
            SayParagraph()
        EndIf
        ;;;TrcExit("SayHTMLParagraphWindow1a")
        return
    EndIf
    ;;;TrcExit("SayHTMLParagraphWindow1b")
    return
EndIf

;;;OutputDebugString(FormatString("iTogglePageReading = %1", IntToString(iTogglePageReading)))
If iTogglePageReading then
	SayAll ()
Else
	SayLine ()
endIf

;;;TrcExit("SayHTMLParagraphWindow")
EndFunction

;=========================================================================
;=========================================================================
; Debug Stuff below here
;=========================================================================
;=========================================================================

;; These routines used for debugging
;; Called on entry/exit to functions and scripts
;;
void Function TrcEnter (string str)
	;;;OutputDebugString(FormatString(">%1", str))
EndFunction

void Function TrcExit(string str)
	;;;OutputDebugString(FormatString("<%1", str))
EndFunction
